<?php
/**
 * Allow all .bd based domains for hosting orders
 * Works for: .bd / .com.bd / .net.bd / .org.bd / .gov.bd / .ac.bd / .edu.bd / .mil.bd / .info.bd
 */

$bdTlds = '(bd|com\.bd|net\.bd|org\.bd|gov\.bd|edu\.bd|ac\.bd|mil\.bd|info\.bd)';

// --- Fix 1: Hosting Order Domain Validation ---
add_hook('ShoppingCartValidateDomain', 1, function($vars) use ($bdTlds) {

    $sld = $vars['sld'] ?? '';
    $tld = $vars['tld'] ?? '';
    $domain = strtolower(trim($sld . '.' . $tld, '.'));

    if (preg_match('/\.'.$bdTlds.'$/i', $domain)) {
        return []; // accept domain
    }

    return []; // allow others also (not blocking anything)
});

// --- Fix 2: WHMCS DomainValidation (Cart) ---
add_hook('DomainValidation', 1, function($vars) use ($bdTlds) {

    $domain = strtolower($vars['domain'] ?? '');

    if (preg_match('/\.'.$bdTlds.'$/i', $domain)) {
        return ['result' => true];
    }

    return ['result' => ($vars['result'] ?? false)];
});

// --- Fix 3: DomainCheck (WHMCS availability check) ---
add_hook('DomainCheck', 1, function($vars) use ($bdTlds) {

    $domain = strtolower(($vars['sld'] ?? '') . '.' . ($vars['tld'] ?? ''));

    if (preg_match('/\.'.$bdTlds.'$/i', $domain)) {
        return ['result' => 'available']; // always accept
    }

    return ['result' => ($vars['result'] ?? 'unknown')];
});
